﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text.RegularExpressions;
using System.Windows.Forms;

namespace MP3修改工具
{
    public partial class SetFileAttributes : Form
    {
        public SetFileAttributes()
        {
            InitializeComponent();
        }


        private void BindGrid()
        {
            this.GridClare();
            this.dataGridView1.DataSource = this.mp3List;
            this.dataGridView1.Refresh();
            this.lblMessage.Text = "批量MP3小说管理工具，列表中共" + this.mp3List.Count + "个文件。";
        }

        private void btnExit_Click(object sender, EventArgs e)
        {
            base.Close();
        }

        private void btnSave_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(this.editPath))
            {
                MessageBox.Show("请选择文件");
            }
            else
            {
                string text = "";
                if (this.ckbEditAll.Checked)
                {
                    int num = 0;
                    foreach (MYMP3 mymp in this.mp3List)
                    {
                        num++;
                        object[] objArray1 = new object[] { "小说属性修改器 - 正在修改第", num, "个文件,文件： ", mymp.FileName };
                        this.Text = string.Concat(objArray1);
                        this.Save(mymp);
                    }
                    text = "您有" + num + "个文件修改完成！";
                }
                else
                {
                    MYMP3 mymp2 = new MYMP3(this.editPath, true);
                    this.Text = "小说属性修改器 - 正在修改 " + mymp2.FileName;
                    this.Save(mymp2);
                    text = "您有1个文件修改完成！";
                }
                this.GetFile();
                this.BindGrid();
                this.Text = "小说属性修改器";
                MessageBox.Show(text);
            }
        }

        private void dataGridView1_CellEnter(object sender, DataGridViewCellEventArgs e)
        {
            if (this.dataGridView1.SelectedRows.Count > 0)
            {
                this.editPath = this.dataGridView1.SelectedRows[0].Cells["filepath"].Value.ToString();
                MYMP3 mymp = new MYMP3(this.editPath, true);
                this.SetText(mymp);
            }
        }


        private void GetFile()
        {
            this.mp3List.Clear();
            if (this.files2.Count > 0)
            {
                this.files.Clear();
                this.files.AddRange(this.files2);
                this.files2.Clear();
            }
            using (List<string>.Enumerator enumerator = this.files.GetEnumerator())
            {
                while (enumerator.MoveNext())
                {
                    MYMP3 item = new MYMP3(enumerator.Current, true);
                    if (item != null)
                    {
                        item.Id = this.mp3List.Count + 1;
                        this.mp3List.Add(item);
                    }
                }
            }
        }

        private void GridClare()
        {
            this.dataGridView1.DataSource = new List<MYMP3>();
            this.dataGridView1.Refresh();
        }


        private void Open_Click(object sender, EventArgs e)
        {
        }

        private void Save(MYMP3 _mp3)
        {
            char[] separator = new char[] { ',' };
            this.txtSplic.Text.Trim().Split(separator);
            string str = string.Empty;
            string number = "0";
            if (this.radioBtn1.Checked)
            {
                number = _mp3.Id.ToString();
            }
            else if (this.radioBtn2.Checked)
            {
                number = _mp3.Number;
            }
            bool flag1 = _mp3.Number == "808";
            if (this.ckTitleByName.Checked)
            {
                str = Regex.Replace(Regex.Replace(Regex.Replace(_mp3.FileName, "{.*?}", string.Empty, RegexOptions.IgnoreCase), @"\[.*?\]", string.Empty, RegexOptions.IgnoreCase), @"\(.*?\)", string.Empty, RegexOptions.IgnoreCase).Replace(".mp3", string.Empty).Replace(_mp3.Number, string.Empty).Replace(_mp3.Id.ToString(), "") + number;
            }
            else
            {
                str = this.txtFileTitle.Text + number;
            }
            _mp3.Artist = this.txtArtist.Text;
            _mp3.Album = this.txtAlbum.Text;
            _mp3.Title = str;
            _mp3.Comment = this.txtComment.Text;
            _mp3.Year = this.txtYear.Text;
            _mp3.Save();
            if (this.ckbEditFileName.Checked && !this.radioBtn3.Checked)
            {
                try
                {
                    FileInfo info = new FileInfo(_mp3.FilePath);
                    info.MoveTo(_mp3.FilePath.Substring(0, _mp3.FilePath.LastIndexOf(_mp3.FileName)) + _mp3.Title + info.Extension);
                    this.files2.Add(_mp3.FilePath.Substring(0, _mp3.FilePath.LastIndexOf(_mp3.FileName)) + _mp3.Title + info.Extension);
                }
                catch
                {
                }
            }
        }

        private void SetFileAttributes_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (MessageBox.Show("确实要退出本系统吗?", "系统提示", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.No)
            {
                e.Cancel = true;
            }
            else
            {
                base.Dispose();
                Environment.Exit(0);
            }
        }

        private void SetText(MYMP3 mp3)
        {
            this.txtAlbum.Text = mp3.Album;
            this.txtArtist.Text = mp3.Artist;
            this.txtComment.Text = mp3.Comment;
            this.txtFileName.Text = mp3.FileName;
            this.txtFileTitle.Text = mp3.Title;
            this.txtYear.Text = mp3.Year;
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            new gy().ShowDialog();
        }

        private void tool打开文件_Click(object sender, EventArgs e)
        {
            this.files.Clear();
            if (DialogResult.OK == this.ofdFile.ShowDialog())
            {
                foreach (string str in this.ofdFile.FileNames)
                {
                    this.files.Add(str);
                }
                this.GetFile();
                this.BindGrid();
            }
        }

        private void 清空列表ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.GridClare();
        }
    }
}
